<?php
/*
 * This file is part of CCount - PHP Click Counter.
 *
 * (c) Copyright 2022 by Klemen Stirn. All rights reserved.
 * https://www.phpjunkyard.com
 * https://www.phpjunkyard.com/php-click-counter.php
 *
 * For the full copyright and license agreement information, please view
 * the docs/index.html file that was distributed with this source code.
 */

define('IN_SCRIPT',1);
define('THIS_PAGE', 'INSTRUCTIONS');

// Require the settings file
require '../ccount_settings.php';

// Load functions
require '../inc/common.inc.php';

// Start session
pj_session_start();

// Are we logged in?
pj_isLoggedIn(true);

// Require admin header
require 'admin_header.inc.php';
?>

<?php pj_processMessages(); ?>

<div class="row">
    <div class="col-lg-12">
        <div class="panel panel-default">
            <div class="panel-heading">
                <h3 class="panel-title">Counting clicks on links</h3>
            </div>
            <div class="panel-body">
                <p>To count clicks on a link (for example to fin out how many times a file has been downloaded), follow these steps:</p>

<ol>
<li>Determine which link you wish to count clicks on, for example:<br>
<code>https://example.com/myFile.zip</code><br>&nbsp;</li>
<li>Open the <a href="new_link.php" class="text-center"><i class="glyphicon glyphicon-plus"></i>&nbsp;New link</a> page and submit your chosen link as a new link.<br>&nbsp;<br>
In our example, you would enter <code>https://example.com/myFile.zip</code> as the <b>Link URL</b>.<br>&nbsp;</li>
<li>When a link is submitted, a special <i>tracking URL</i> is generated by CCount. For example:<br>
<code>https://example.com/ccount/click.php?id=<b>123</b></code><br>&nbsp;</li>
<li>To count clicks, use the generated tracking URL in your website instead of the original link.<br>&nbsp;</li>
<li>Then, when a visitor clicks<br>
<code>https://example.com/ccount/click.php?id=<b>123</b></code><br>
CCount will count the click and redirect the visitor to the destination page:<br>
<code>https://example.com/myFile.zip</code><br>&nbsp;<br>&nbsp;Simple, but effective!</li>
</ol>

            </div>
        </div>
    </div>
</div>

<div class="row">
    <div class="col-lg-12">
        <div class="panel panel-default">
            <div class="panel-heading">
                <h3 class="panel-title">Redirect types</h3>
            </div>
            <div class="panel-body">
                <p>CCount supports three types of redirects:</p>

<ol>
<li><strong>temporary (HTTP 302 Moved Temporarily)</strong><br>
This is the most common and recommended redirect type. If unsure, use this option.<br>&nbsp;</li>
<li><strong>permanent (HTTP 301 Moved Permanently)</strong><br>
This redirect type possibly has SEO benefits. However, browsers may cache this redirect type and not track subsequent clicks on the link from the same user. Also, browsers with cached redirects may ignore any changes you make to existing links.<br>&nbsp;</li>
<li><strong>force download</strong><br>
Use this redirect type when you want to force the browser to download a file (PDF, Word, image, ...) rather than display it inside the browser.<br><br>
For forced downloads to work, CCount must first download the file from the URL and then send it to the user.<br><br>
Force download requirements:
<ol>
<li>Your server must allow downloading from URL addresses: <?php
if (! ini_get('allow_url_fopen') )
{
    echo '<span style="color:green">allow_url_fopen is enabled on your server</span>';
}
else
{
    echo '<span style="color:red">allow_url_fopen is disabled on your server. You will need to enable it in your PHP configuration for forced downloads to work in CCount. If not sure, ask your hosting company to enable <strong>allow_url_fopen</strong> in your PHP.</span>';
}
?></li>
<li>File name will be set to the <strong>Link title</strong>; set it to the correct name, for example, <strong>Document.pdf</strong>, <strong>car.jpg</strong>, <strong>request_form.docx</strong></li>
<li>Reading files via URL is not memory-friendly. We only recommend using CCount forced downloads for serving small files.<br>
How small is small enough? Files less than 1 Mb should be fine, but it depends on your server, so test any larger files to be sure.</li>
</ul>

</li>
</ol>

            </div>
        </div>
    </div>
</div>

<div class="row">
    <div class="col-lg-12">
        <div class="panel panel-default">
            <div class="panel-heading">
                <h3 class="panel-title">Displaying click count on your website</h3>
            </div>
            <div class="panel-body">

                <div class="alert alert-warning">
                    <strong>Important:</strong> if you want to keep click statistics strictly private you should delete file <b>display.php</b> from the server!
                </div>

                <p>You can always view click statistics in CCount admin pages. However, you can also display link count publicly.</p>

                <p>&nbsp;<br><b>Step 1</b></p>

                <p>Place the following code in the head of the web page (between <code>&lt;head&gt;</code> and <code>&lt;/head&gt;</code> tags), where you wish to display count statistics:<br>&nbsp;<br>
                <?php
                if ( isset($_SERVER['HTTP_HOST']) && isset($_SERVER['REQUEST_URI']) && strpos($_SERVER['REQUEST_URI'], '/admin/instructions.php') !== false )
                {
                    $url = ((isset($_SERVER['HTTPS']) && strtolower($_SERVER['HTTPS']) == 'on') ? 'https://' : 'http://') . $_SERVER['HTTP_HOST'] . str_replace('/admin/instructions.php', '/display.php', $_SERVER['REQUEST_URI']);
                }
                else
                {
                    $url = 'https://example.com/ccount/display.php';
                }
                ?>
                <code>&lt;script src=&quot;<?php echo $url; ?>&quot;&gt;&lt;/script&gt;</code>
                <?php
                if ($url == 'https://example.com/ccount/display.php')
                {
                    echo "<br>&nbsp;<br>(change <code>https://example.com/ccount/display.php</code> to the URL of <code>display.php</code> on your server)";
                }
                ?>
                </p>

                <p>&nbsp;<br><b>Step 2</b></p>

                <p>Place the following code in your web page exactly where you want the count to appear:</p>

<ol>

<li>
Total clicks on a link:<br>&nbsp;<br>
<code>&lt;script&gt;ccount_display('<b>LINK_ID</b>')&lt;/script&gt;</code>
<br>&nbsp;<br>Replace <code>LINK_ID</code> with the actual link ID. In the first example generated ID was <b>123</b>, so the actual code to display count would be:<br>&nbsp;<br>
<code>&lt;script&gt;ccount_display('<b>123</b>')&lt;/script&gt;</code>
<br>&nbsp;
</li>

<li>
Unique clicks on a link:<br>&nbsp;<br>
<code>&lt;script&gt;ccount_<b>unique</b>('LINK_ID')&lt;/script&gt;</code>
<br>&nbsp;
</li>

<li>
Total clicks on all links:<br>&nbsp;<br>
<code>&lt;script&gt;ccount_<b>total</b>()&lt;/script&gt;</code>
<br>&nbsp;
</li>

<li>
Total unique clicks on all links:<br>&nbsp;<br>
<code>&lt;script&gt;ccount_<b>total_unique</b>()&lt;/script&gt;</code>
<br>&nbsp;
</li>

<li>
Sum of clicks for specific links:<br>&nbsp;<br>
<code>&lt;script&gt;ccount_<b>sum</b>('ID1', 'ID2', ...)&lt;/script&gt;</code>
<br>&nbsp;<br>
For example to show a sum of total clicks for links with ID <b>test</b>, <b>4</b> and <b>9</b> you would use:<br>&nbsp;<br>
<code>&lt;script&gt;ccount_sum('<b>test</b>', '<b>4</b>', '<b>9</b>')&lt;/script&gt;</code>
<br>&nbsp;
</li>

<li>
Sum of unique clicks for specific links:<br>&nbsp;<br>
<code>&lt;script&gt;ccount_<b>sum_unique</b>('ID1', 'ID2', ...)&lt;/script&gt;</code>
<br>&nbsp;
</li>

</ol>

            </div>
        </div>
    </div>
</div>


<div class="row">
    <div class="col-lg-12">
         <div class="panel panel-default">
            <div class="panel-heading">
                <h3 class="panel-title">Stay updated</h3>
            </div>
            <div class="panel-body">
                <p>Want to stay up-to-date with news from PHP Junkyard?</p>
                <p>Join my free newsletter. Low volume. No SPAM.</p>
                <p><a href="https://www.phpjunkyard.com/support/newsletter.php" target="_blank"><i class="glyphicon glyphicon-globe"></i>&nbsp;Join Newsletter</a></p>
            </div>
        </div>
    </div>
</div>

<?php

// Get footer
include('admin_footer.inc.php');
